package com.hero.util;

import org.jdom.Element;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class XMLUtility {

	/**
	 * A simple utility that will grab the (String) value of the named element
	 * or attribute in the Element specified. The child elements will be
	 * searched first, if no match is found, the attributes will be searched.
	 * 
	 * @param root
	 *            The root element.
	 * @param id
	 *            The name of the element/attribute to find.
	 * @return The value of the element/attribute (or empty string if none)
	 */
	public static String getValue(Element root, String id) {
		if ((id == null) || (root == null)) {
			return "";
		}
		try {
			if ((root.getChildText(id) == null)
					|| (root.getChildText(id).trim().length() == 0)) {
				if (root.getAttribute(id) != null) {
					return root.getAttribute(id).getValue();
				} else {
					return "";
				}
			} else {
				return root.getChildText(id);
			}
		} catch (Exception exp) {
			exp.printStackTrace();
		}
		return "";
	}
}